**********************************************************************
*This program combines key variables from SIH loan-level data from 2007/08 to 2017/18 as well as 2003/04 HES loan-level data 
*Offset accoutn is separated from deposits from 2010/11 
**********************************************************************
cd "<place directory here>"
global path "<place directory here>"
global data "$path\data"
global rawdata "$path\rawdata" //this is where you save the raw SIH data 


*******************************************
clear
use "$path\rawwdata\SIH17BL.dta"

gen year=2018

*L is amount of principal outstanding on loan
rename amtoln L
*L_borrow is amount borrowed 
rename amtbrln L_borrow
rename yrrpmtl year_loan_originated

keep L L_borrow year_loan_originated abshid abslid year mpurl curintl wkrepln


save "$path\data\2017loan.dta" 

clear
use "$path\rawdata\SIH15BL.dta"

gen year=2016
*L is amount of principal outstanding on loan
rename amtoln L
*L_borrow is amount borrowed 
rename amtbrln L_borrow
rename yrrpmtl year_loan_originated

keep L L_borrow year_loan_originated abshid abslid year mpurl curintl wkrepln


save "$path\data\2015loan.dta"


clear
use "$path\rawdata\SIH13bl.dta"

gen year=2014

*L is amount of principal outstanding on loan
rename AMTOLN L

*L_borrow is amount borrowed 
rename AMTBRLN L_borrow
rename YRRPMTL year_loan_originated
rename ABSHID abshid
rename ABSLID abslid
rename MPURL mpurl
rename CURINTL curintl
rename WKREPLN wkrepln
keep L L_borrow year_loan_originated abshid abslid year mpurl curintl wkrepln

save "$path\data\2013loan.dta"



clear
use "$path\rawdata\SIH11bl.dta"

gen year=2012

*L is amount of principal outstanding on loan
rename AMTOLN L

*L_borrow is amount borrowed 
rename AMTBRLN L_borrow
rename YRRPMTL year_loan_originated
rename ABSHID abshid
rename ABSLID abslid
rename MPURL mpurl
rename CURINTL curintl
rename WKREPLN wkrepln
keep L L_borrow year_loan_originated abshid abslid year mpurl curintl wkrepln

save "$path\data\2011loan.dta"


clear
use "$path\rawdata\SIH10bl.dta"
gen year=2010

*L is amount of principal outstanding on loan
rename AMTOLN L

*L_borrow is amount borrowed 
rename AMTBRLN L_borrow
rename YRRPMTL year_loan_originated
rename ABSHID abshid
rename ABSLID abslid
rename MPURL mpurl
rename CURINTL curintl
rename WKREPLN wkrepln
keep L L_borrow year_loan_originated abshid abslid year mpurl curintl wkrepln

save "$path\data\2009loan.dta"



clear
use "$path\rawdata\SIH08BL.dta"

gen year=2008

*L is amount of principal outstanding on loan
rename AMTOLN L

*L_borrow is amount borrowed 
rename AMTBRLN L_borrow
rename YRRPMTL year_loan_originated
rename ABSHID abshid
rename ABSLID abslid
rename MPURL mpurl
rename CURINTL curintl
rename WKREPLN wkrepln

keep L L_borrow year_loan_originated abshid abslid year mpurl  curintl wkrepln

save "$path\data\2007loan.dta"




clear
use "$path\rawdata\hes03bl.dta" 
gen year=2004 

rename AMTOLN L
rename AMTBRLN L_borrow
rename YRRPMTL year_loan_originated
rename ABSHID abshid
rename LOANNUMB abslid
rename MPURL mpurl
rename CURINTL curintl
rename WKREPLN wkrepln


keep L L_borrow year_loan_originated abshid abslid year mpurl curintl wkrepln


save "$path\data\2004loan.dta"






************** APPENDING DATASETS ************** 
*without 2004 HES data
clear

append using "$path\data\2017loan.dta"
append using "$path\data\2015loan.dta" 
append using "$path\data\2013loan.dta" 
append using "$path\data\2011loan.dta" 
append using "$path\data\2009loan.dta" 
append using "$path\data\2007loan.dta" 

save "$path\data\loan.dta" 


*with 2004 HES data
clear
append using "$path\data\2004loan.dta" 
append using "$path\data\2017loan.dta" , force
append using "$path\data\2015loan.dta" , force
append using "$path\data\2013loan.dta" , force
append using "$path\data\2011loan.dta" , force
append using "$path\data\2009loan.dta" , force
append using "$path\data\2007loan.dta" , force

save "$path\data\loan_HES.dta" 









